# 通知設計書 2-Syslog ERR通知

## 概要

本ドキュメントは、Horse WebフレームワークのDaemonプロバイダーにおけるSyslog ERR通知機能の設計を記述する。デーモン実行時にエラーが発生した場合に、システムログ（syslog）へエラー情報を記録する通知機能である。

### 本通知の処理概要

本通知は、LinuxデーモンとしてHorseサーバーが動作中にエラーが発生した際に、システムログファシリティを通じてエラー情報を記録する機能を提供する。

**業務上の目的・背景**：Linuxサーバー環境でデーモンとして動作するWebサーバーの運用において、エラー発生時の情報をシステムログに記録することは障害対応の基本要件である。この通知により、システム管理者はsyslogを通じてエラーの発生を即座に検知でき、例外クラス名とエラーメッセージから問題の原因特定が可能となる。

**通知の送信タイミング**：デーモンプロセスの起動処理中またはメインループ実行中に例外が発生した場合に送信される。具体的には、HTTPサーバーの起動処理（StartListening等）で例外が発生した場合、およびメインイベントループで予期しない例外が発生した場合に送信される。

**通知の受信者**：システムログデーモン（syslogd/rsyslogd）を経由して、ログファイル（通常は`/var/log/daemon.log`または`/var/log/messages`）に記録される。受信者はシステム管理者、運用監視システム、ログ分析ツールである。

**通知内容の概要**：例外のクラス名とエラーメッセージを含むエラー情報。形式は「{ExceptionClassName}: {ExceptionMessage}」または「Error: {ErrorMessage}」である。

**期待されるアクション**：システム管理者はエラーの発生を検知し、例外クラス名とメッセージから原因を特定して対処する。監視システムはLOG_ERR優先度のログを検知してアラートを発報する。

## 通知種別

システムログ（Syslog） - LOG_ERR優先度

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期 |
| 優先度 | ERR（LOG_ERR = 3） |
| リトライ | 無し |

### 送信先決定ロジック

syslogシステムコールにより、OSのシステムログデーモンに送信される。ログのルーティングはsyslog設定（`/etc/rsyslog.conf`等）に従う。ファシリティは`LOG_DAEMON`（デーモン関連メッセージ）が使用される。LOG_ERR優先度は通常、即座にログファイルに書き込まれ、rsyslogの設定によってはリモートサーバーへの転送も行われる。

## 通知テンプレート

### システムログ通知の場合

| 項目 | 内容 |
|-----|------|
| ファシリティ | LOG_DAEMON（3 << 3 = 24） |
| 優先度 | LOG_ERR（3） |
| オプション | LOG_PID \| LOG_NDELAY |
| 形式 | テキスト |

### 本文テンプレート

起動処理中のエラー：
```
{ExceptionClassName}: {ExceptionMessage}
```

メインループ中のエラー：
```
Error: {ErrorMessage}
```

実際の出力例：
```
EIdSocketError: Connection refused
Error: Socket read error
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| なし | - | - | システムログ通知のため添付ファイルは使用しない |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| E.ClassName | 例外クラス名 | Exception.ClassName | Yes |
| E.Message | 例外メッセージ | Exception.Message | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 起動エラー | InternalListen内try-except（内側） | StartListening等で例外発生 | HTTPサーバー起動処理でのエラー |
| 実行エラー | InternalListen内try-except（外側） | メインループで例外発生 | デーモン実行中の予期しないエラー |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 非デーモンモード | HORSE_DAEMONが定義されていない場合は本コードは実行されない |
| syslog未初期化 | openlogが呼ばれる前にエラーが発生した場合（fork前など） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[InternalListen呼び出し] --> B[openlogでsyslog初期化]
    B --> C[fork処理でデーモン化]
    C --> D[HTTPサーバー設定]
    D --> E[StartListening実行]
    E --> F{例外発生?}
    F -->|発生| G[Syslog LOG_ERR 送信 - 起動エラー]
    G --> H[例外処理継続]
    F -->|なし| I[イベントループ開始]
    I --> J{ループ中に例外?}
    J -->|発生| K[Syslog LOG_ERR 送信 - 実行エラー]
    K --> L[ExitCode = EXIT_FAILURE]
    L --> M[終了処理]
    J -->|なし| N[正常終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| なし | - | 本通知はデータベースを使用しない |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| なし | - | 本通知はデータベースを更新しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ソケットエラー | ポートが既に使用中、権限不足等 | ログ記録後、デーモンはEXIT_FAILUREで終了 |
| 設定エラー | 不正なホスト/ポート設定 | ログ記録後、デーモンはEXIT_FAILUREで終了 |
| SSL初期化エラー | 証明書ファイル不正等 | ログ記録後、デーモンはEXIT_FAILUREで終了 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

エラー発生時に即座に送信される。時間帯の制限はない。

## セキュリティ考慮事項

- 例外クラス名とメッセージのみをログに記録するため、スタックトレースや詳細なデバッグ情報は含まれない
- 例外メッセージに機密情報が含まれる可能性がある場合は、アプリケーション側での考慮が必要
- syslogへの書き込み権限はOSレベルで管理される
- LOG_ERRは高優先度のため、多くのシステムでリアルタイムに記録・転送される

## 備考

- `HORSE_DAEMON`コンパイラディレクティブが定義されている場合のみ有効
- 2箇所のtry-exceptブロックで異なる形式のエラーメッセージが出力される
- 起動エラー時は「ClassName: Message」形式、実行エラー時は「Error: Message」形式

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

syslogの優先度定数とエラーメッセージの構成要素を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | LOG_ERR定数（行59、値=3）を確認 |

**読解のコツ**: LOG_ERRは緊急度が高い（0が最高、7が最低）。通常の運用監視では3以下をアラート対象とすることが多い。

#### Step 2: エントリーポイントを理解する

エラー発生箇所とログ出力の関係を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | InternalListenメソッド内の2つのtry-exceptブロック（行236-264、行268-274）を確認 |

**主要処理フロー**:
1. **行236**: 内側try開始（HTTPサーバー起動処理）
2. **行261-264**: 内側except - 起動エラー時のLOG_ERR送信
   - `Syslog(LOG_ERR, E.ClassName + ': ' + E.Message)`
3. **行268-274**: 外側except - メインループエラー時のLOG_ERR送信
   - `Syslog(LOG_ERR, 'Error: ' + E.Message)`
4. **行272**: `ExitCode := EXIT_FAILURE`

#### Step 3: 例外処理の詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | try-except構造の入れ子関係を確認 |

**主要処理フロー**:
- **行229-264**: 内側のtry-except（起動処理用）
- **行229-274**: 外側のtry-except（全体エラーハンドリング用）

### プログラム呼び出し階層図

```
THorseProvider.Listen (public)
    │
    └─ THorseProvider.InternalListen (private, 行195)
           │
           ├─ openlog (行203)
           │
           ├─ try (外側, 行229)
           │      │
           │      ├─ try (内側, 行236)
           │      │      │
           │      │      ├─ LIdHTTPWebBrokerBridge.StartListening (行257)
           │      │      │
           │      │      └─ except (行261-264)
           │      │             │
           │      │             └─ Syslog(LOG_ERR, E.ClassName + ': ' + E.Message)
           │      │                    起動エラー通知
           │      │
           │      └─ except (行268-274)
           │             │
           │             ├─ Syslog(LOG_ERR, 'Error: ' + E.Message)
           │             │      実行エラー通知
           │             │
           │             └─ ExitCode := EXIT_FAILURE
           │
           └─ closelog (行276)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

Exception発生      ───┬──▶ E.ClassName取得           ───▶ syslog
                      │           │                          /var/log/daemon.log
                      │           ▼
                      │    E.Message取得
                      │           │
                      │           ▼
                      │    文字列連結
                      │    "{ClassName}: {Message}"
                      │    または
                      │    "Error: {Message}"
                      │           │
                      └───────────▼
                           Syslog(LOG_ERR, message)
                                  │
                                  ▼
                           _syslog(LOG_ERR, ...)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Horse.Provider.Daemon.pas | `src/Horse.Provider.Daemon.pas` | ソース | デーモンプロバイダーのメイン実装、ERR通知の送信元 |
| ThirdParty.Posix.Syslog.pas | `src/ThirdParty.Posix.Syslog.pas` | ソース | syslog APIのDelphiラッパー、LOG_ERR定数定義 |
| Horse.Constants.pas | `src/Horse.Constants.pas` | ソース | EXIT_FAILURE/EXIT_SUCCESS定数（ただしDaemon.pas内で再定義） |
